/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.LinkLayerCompTest;

import com.quantumdata.LinkLayerCompTest.DPSinkPanel;
import com.quantumdata.LinkLayerCompTest.DPSourcePanel;
import com.quantumdata.LinkLayerCompTest.SinkPage;
import com.quantumdata.LinkLayerCompTest.SourcePage;
import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class llctGui
extends QDPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static RemoteInstrument m_instrument = null;
    private static InstrumentResponse m_lastResp;
    private IQDPluginContext m_context;
    private BorderLayout m_layout;
    private JTabbedPane m_SinkSource;
    private static QDLabel m_errMsg;
    private SourcePage m_sourcePage;
    private SinkPage m_sinkPage;
    private DPSourcePanel m_sourceConfigPage;
    private DPSinkPanel m_sinkConfigPage;
    private QDButton m_LoadButton;
    private QDButton m_SaveButton;
    private QDToolBar m_ToolBar;
    private QDLabel m_VersionLabel;
    private JScrollPane m_sourceConfigScroll;
    private JScrollPane m_sinkConfigScroll;
    private JScrollPane m_sourceScroll;
    private JScrollPane m_sinkScroll;
    private int m_currentlySelectedTab;

    public llctGui(IQDPluginContext iQDPluginContext) {
        this.m_context = iQDPluginContext;
        this.initGui();
    }

    public llctGui() {
        this.initGui();
    }

    public void initGui() {
        this.m_layout = new BorderLayout();
        this.setLayout(this.m_layout);
        m_errMsg = new QDLabel("Not Connected");
        m_errMsg.setForeground(Color.red);
        this.add((Component)m_errMsg, "South");
        this.m_SinkSource = new JTabbedPane();
        this.add((Component)this.m_SinkSource, "Center");
        this.m_sinkPage = new SinkPage(this);
        this.m_sourcePage = new SourcePage(this);
        this.m_sourceConfigPage = new DPSourcePanel(this);
        this.m_sinkConfigPage = new DPSinkPanel(this);
        this.m_sourceConfigScroll = new JScrollPane(this.m_sourceConfigPage);
        this.m_sinkConfigScroll = new JScrollPane(this.m_sinkConfigPage);
        this.m_sourceScroll = new JScrollPane(this.m_sourcePage);
        this.m_sinkScroll = new JScrollPane(this.m_sinkPage);
        this.m_SinkSource.addTab("Sink Config", this.m_sinkConfigScroll);
        this.m_SinkSource.addTab("Sink", this.m_sinkScroll);
        this.m_SinkSource.addTab("Source Config", this.m_sourceConfigScroll);
        this.m_SinkSource.addTab("Source", this.m_sourceScroll);
        this.m_SinkSource.addChangeListener(this);
        this.m_ToolBar = new QDToolBar();
        this.m_ToolBar.setLayout(new GridLayout(1, 2));
        this.m_LoadButton = new QDButton("Load From File");
        this.m_LoadButton.addActionListener(new LoadButtonListener(this));
        this.m_SaveButton = new QDButton("Save To File");
        this.m_SaveButton.addActionListener(new SaveButtonListener(this));
        this.m_VersionLabel = new QDLabel("");
        QDPanel qDPanel = new QDPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        qDPanel.setLayout(flowLayout);
        qDPanel.add(this.m_LoadButton);
        qDPanel.add(this.m_SaveButton);
        QDPanel qDPanel2 = new QDPanel();
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(2);
        qDPanel2.setLayout(flowLayout2);
        qDPanel2.add(this.m_VersionLabel);
        this.m_ToolBar.add(qDPanel);
        this.m_ToolBar.add(qDPanel2);
        this.add((Component)this.m_ToolBar, "North");
        Dimension dimension = new Dimension(900, 900);
        this.setSize(900, 900);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setVisible(true);
    }

    public void start() {
        this.start(this.m_context.getConnectionManager().getDefaultInstrument());
    }

    public void start(RemoteInstrument remoteInstrument) {
        m_instrument = remoteInstrument;
        if (m_instrument == null) {
            this.setErrorMsg("Not Connected");
        } else {
            boolean bl = false;
            boolean bl2 = false;
            try {
                String string = this.sendCmd("*IDN?");
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                if (stringTokenizer.countTokens() > 1) {
                    string = stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                }
                stringTokenizer = new StringTokenizer(string, "-");
                int n = stringTokenizer.countTokens();
                for (int i = 0; i < n; ++i) {
                    string = stringTokenizer.nextToken();
                    if (string.equals("DPLL1")) {
                        bl = true;
                        continue;
                    }
                    if (!string.equals("DPLL2")) continue;
                    bl2 = true;
                }
                this.setErrorMsg("");
                if (bl) {
                    this.m_sinkPage.UpdateStatus();
                    this.m_sinkConfigPage.UpdateStatus();
                } else {
                    this.m_SinkSource.setEnabledAt(1, false);
                    if (this.m_SinkSource.getSelectedIndex() == 0) {
                        this.m_SinkSource.setSelectedIndex(2);
                    }
                }
                if (bl2) {
                    this.m_sourcePage.UpdateStatus();
                    this.m_sourceConfigPage.UpdateStatus();
                } else {
                    this.m_SinkSource.setEnabledAt(3, false);
                    if (this.m_SinkSource.getSelectedIndex() == 2) {
                        this.m_SinkSource.setSelectedIndex(0);
                    }
                }
                this.m_currentlySelectedTab = this.m_SinkSource.getSelectedIndex();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.setVersionTitle();
    }

    private void setVersionTitle() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("LLCT:  ");
        try {
            stringBuffer.append("" + this.getInstrument().getConnection().getName() + " - ");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        stringBuffer.append("Version 1.16");
        this.m_VersionLabel.setText(stringBuffer.toString());
    }

    public boolean stop() {
        return true;
    }

    public RemoteInstrument getInstrument() {
        return m_instrument;
    }

    public String sendCmd(String string) throws InstrumentException {
        if (m_instrument == null) {
            m_errMsg.setText("Not Connected");
            throw new InstrumentException("Not Connected");
        }
        m_lastResp = m_instrument.sendCmd(string);
        if (m_lastResp.isError()) {
            m_errMsg.setText(m_lastResp.getResponse());
            throw new InstrumentException(m_lastResp.getResponse());
        }
        m_errMsg.setText("");
        return m_lastResp.getResponse();
    }

    public int getInt(String string) throws InstrumentException {
        String string2 = this.sendCmd(string);
        return Integer.parseInt(string2);
    }

    public void setErrorMsg(String string) {
        m_errMsg.setText(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.m_SinkSource) {
            String string = this.m_SinkSource.getTitleAt(this.m_currentlySelectedTab);
            if (string.equalsIgnoreCase("Source Config")) {
                this.m_sourceConfigPage.SendBackStatus();
            } else if (string.equalsIgnoreCase("Sink Config")) {
                this.m_sinkConfigPage.SendBackStatus();
            }
            this.m_currentlySelectedTab = this.m_SinkSource.getSelectedIndex();
            try {
                string = this.m_SinkSource.getTitleAt(this.m_currentlySelectedTab);
                if (string.equalsIgnoreCase("Source")) {
                    int n = this.getInt("dprx:satw?");
                    this.m_sourcePage.setWaitTimeSpn(n);
                } else if (string.equalsIgnoreCase("Sink")) {
                    int n = this.getInt("dptx:satw?");
                    this.m_sinkPage.setWaitTimeSpn(n);
                }
            }
            catch (InstrumentException instrumentException) {
                return;
            }
        }
    }

    class SaveButtonListener
    implements ActionListener {
        private static final String sDialogTitle = "Save Configuration File Dialog";
        private llctGui m_MainWindow;
        private boolean m_FileAlreadyExists = false;

        public SaveButtonListener(llctGui llctGui3) {
            this.m_MainWindow = llctGui3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_MainWindow.getInstrument() != null) {
                int n = llctGui.this.m_SinkSource.getSelectedIndex();
                if (n == 0 || n == 1) {
                    this.Save("dptx");
                } else if (n == 2 || n == 3) {
                    this.Save("dprx");
                } else {
                    String string = "Please Select Either 'Sink Config' or 'Source Config' Tabs For This Operation";
                    JOptionPane.showMessageDialog(this.m_MainWindow, string, sDialogTitle, 0);
                }
            } else {
                String string = "Cannot Access Generator";
                JOptionPane.showMessageDialog(this.m_MainWindow, string, sDialogTitle, 0);
            }
        }

        private void Save(String string) {
            String string2;
            int n;
            String string3 = JOptionPane.showInputDialog(this.m_MainWindow, "Enter A FileName:", sDialogTitle, -1);
            boolean bl = this.ConnectionEstablished(string + ":cfgp?", string3);
            if (this.m_FileAlreadyExists && bl && (n = JOptionPane.showConfirmDialog(this.m_MainWindow, string2 = "File '" + string3 + "' Already Exists\nDo You Want To Overwrite?", sDialogTitle, 0)) == 1) {
                bl = false;
            }
            if (bl) {
                try {
                    if (string.equalsIgnoreCase("dprx")) {
                        llctGui.this.m_sourceConfigPage.SendBackStatus();
                    } else if (string.equalsIgnoreCase("dptx")) {
                        llctGui.this.m_sinkConfigPage.SendBackStatus();
                    }
                    this.m_MainWindow.sendCmd(string + ":cfga " + string3);
                }
                catch (InstrumentException instrumentException) {
                    String string4 = "Error Saving File '" + string3 + "'\n" + instrumentException.toString();
                    JOptionPane.showMessageDialog(this.m_MainWindow, string4, sDialogTitle, 0);
                }
            }
        }

        private boolean ConnectionEstablished(String string, String string2) {
            boolean bl;
            block9: {
                bl = true;
                this.m_FileAlreadyExists = false;
                FtpConnect ftpConnect = new FtpConnect();
                Ftp ftp = new Ftp();
                SocketConnection socketConnection = (SocketConnection)this.m_MainWindow.getInstrument().getConnection();
                ftpConnect.setHostName(socketConnection.getHostName());
                ftpConnect.setPassWord("");
                ftpConnect.setUserName("");
                boolean bl2 = false;
                try {
                    bl2 = ftp.connect(ftpConnect);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.m_MainWindow, iOException.getMessage(), sDialogTitle, 0);
                    ftp.disconnect();
                    bl = false;
                }
                if (bl2) {
                    try {
                        String string3 = this.m_MainWindow.sendCmd(string);
                        if (ftp.cd(string3)) {
                            FtpFile ftpFile = new FtpFile(".", ftp);
                            if (ftpFile.isDirectory()) {
                                CoFile[] coFileArray = ftpFile.listCoFiles();
                                for (int i = 0; i < coFileArray.length; ++i) {
                                    if (!coFileArray[i].getName().equalsIgnoreCase(string2)) continue;
                                    this.m_FileAlreadyExists = true;
                                    break block9;
                                }
                                break block9;
                            }
                            String string4 = "Not a directory: \"" + string3 + "\"";
                            JOptionPane.showMessageDialog(this.m_MainWindow, string4, sDialogTitle, 0);
                            ftp.disconnect();
                            bl = false;
                            break block9;
                        }
                        String string5 = "Unable To Access Path:  \"" + string3 + "\"";
                        JOptionPane.showMessageDialog(this.m_MainWindow, string5, sDialogTitle, 0);
                        ftp.disconnect();
                        bl = false;
                    }
                    catch (InstrumentException instrumentException) {
                        String string6 = "Error In Extracting File Locations";
                        JOptionPane.showMessageDialog(this.m_MainWindow, string6, sDialogTitle, 0);
                        ftp.disconnect();
                        bl = false;
                    }
                } else {
                    String string7 = "Unable To Access Generator FTP";
                    JOptionPane.showMessageDialog(this.m_MainWindow, string7, sDialogTitle, 0);
                    ftp.disconnect();
                    bl = false;
                }
            }
            return bl;
        }
    }

    class LoadButtonListener
    implements ActionListener {
        private static final String sDialogTitle = "Load Configuration File Dialog";
        private llctGui m_MainWindow;

        public LoadButtonListener(llctGui llctGui3) {
            this.m_MainWindow = llctGui3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_MainWindow.getInstrument() != null) {
                int n = llctGui.this.m_SinkSource.getSelectedIndex();
                if (n == 0 || n == 1) {
                    this.Load("dptx");
                } else if (n == 2 || n == 3) {
                    this.Load("dprx");
                } else {
                    String string = "Please Select Either 'Sink Config' or 'Source Config' Tabs For This Operation";
                    JOptionPane.showMessageDialog(this.m_MainWindow, string, sDialogTitle, 0);
                }
            } else {
                String string = "Cannot Access Generator";
                JOptionPane.showMessageDialog(this.m_MainWindow, string, sDialogTitle, 0);
            }
        }

        private void Load(String string) {
            String string2;
            Object[] objectArray = this.GetFileList(string + ":cfgp?");
            if (objectArray != null && objectArray.length >= 1 && (string2 = (String)JOptionPane.showInputDialog(this.m_MainWindow, "Choose A File:", sDialogTitle, -1, null, objectArray, objectArray[0])) != null && string2.length() > 0) {
                String string3 = string + ":cfgl " + string2;
                try {
                    this.m_MainWindow.sendCmd(string3);
                    if (string.equalsIgnoreCase("dprx")) {
                        llctGui.this.m_sourceConfigPage.UpdateStatus();
                    } else if (string.equalsIgnoreCase("dptx")) {
                        llctGui.this.m_sinkConfigPage.UpdateStatus();
                    }
                }
                catch (InstrumentException instrumentException) {
                    String string4 = "Error Loading File '" + string2 + "'\n" + instrumentException.toString();
                    JOptionPane.showMessageDialog(this.m_MainWindow, string4, sDialogTitle, 0);
                }
            }
        }

        private String[] GetFileList(String string) {
            String[] stringArray;
            block12: {
                Object object;
                stringArray = null;
                FtpConnect ftpConnect = new FtpConnect();
                Ftp ftp = new Ftp();
                SocketConnection socketConnection = (SocketConnection)this.m_MainWindow.getInstrument().getConnection();
                ftpConnect.setHostName(socketConnection.getHostName());
                ftpConnect.setPassWord("");
                ftpConnect.setUserName("");
                boolean bl = false;
                try {
                    bl = ftp.connect(ftpConnect);
                }
                catch (IOException iOException) {
                    object = "Error Connecting To Generator\n" + iOException.getMessage();
                    JOptionPane.showMessageDialog(this.m_MainWindow, object, sDialogTitle, 0);
                    ftp.disconnect();
                }
                if (bl) {
                    try {
                        String string2 = this.m_MainWindow.sendCmd(string);
                        if (ftp.cd(string2)) {
                            object = new FtpFile(".", ftp);
                            if (((FtpFile)object).isDirectory()) {
                                CoFile[] coFileArray = ((FtpFile)object).listCoFiles();
                                if (coFileArray != null && coFileArray.length >= 1) {
                                    stringArray = new String[coFileArray.length];
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        stringArray[i] = coFileArray[i].getName();
                                    }
                                } else {
                                    String string3 = string.startsWith("dprx") ? "Source" : "Sink";
                                    String string4 = "No Files Available In " + string3 + " Path '" + string2 + "'";
                                    JOptionPane.showMessageDialog(this.m_MainWindow, string4, sDialogTitle, 0);
                                    ftp.disconnect();
                                }
                            } else {
                                String string5 = "Not a directory: \"" + string2 + "\"";
                                JOptionPane.showMessageDialog(this.m_MainWindow, string5, sDialogTitle, 0);
                                ftp.disconnect();
                            }
                            break block12;
                        }
                        object = "Unable To Access Path:  \"" + string2 + "\"";
                        JOptionPane.showMessageDialog(this.m_MainWindow, object, sDialogTitle, 0);
                        ftp.disconnect();
                    }
                    catch (InstrumentException instrumentException) {
                        object = "Error In Extracting File Locations";
                        JOptionPane.showMessageDialog(this.m_MainWindow, object, sDialogTitle, 0);
                        ftp.disconnect();
                    }
                } else {
                    String string6 = "Unable To Access Generator FTP";
                    JOptionPane.showMessageDialog(this.m_MainWindow, string6, sDialogTitle, 0);
                    ftp.disconnect();
                }
            }
            return stringArray;
        }
    }
}

